/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.mapgen.rendering.camera;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.math.Vector2;
import technology.rocketjump.undermount.mapgen.model.AbstractGameMap;

public class PrimaryCameraManager {
    private static final float XY_MOVEMENT_SPEED = 4.0f;
    public static final float ZOOM_SPEED = 10.0f;
    private final OrthographicCamera camera;
    private Vector2 xyVelocity = new Vector2();
    private float targetZoom = 2.0f;
    private static final float MAX_ZOOM = 10.0f;
    private static final float MIN_ZOOM = 0.3f;
    private int worldWidth;
    private int worldHeight;

    public PrimaryCameraManager() {
        this.camera = new OrthographicCamera();
        this.camera.setToOrtho(false, (float)Gdx.graphics.getWidth() / 100.0f, (float)Gdx.graphics.getHeight() / 100.0f);
        this.camera.zoom = 2.0f;
    }

    public void zoom(int zoomAmount) {
        this.targetZoom = this.camera.zoom + this.camera.zoom * (float)zoomAmount * 0.5f;
        if (this.targetZoom < 0.3f) {
            this.targetZoom = 0.3f;
        } else if (this.targetZoom > 10.0f) {
            this.targetZoom = 10.0f;
        }
    }

    public void update(float deltaSeconds) {
        float difference;
        this.camera.position.x += this.xyVelocity.x * deltaSeconds * 4.0f * this.camera.zoom;
        if (this.camera.position.x < 0.0f) {
            this.camera.position.x = 0.0f;
        } else if (this.camera.position.x > (float)this.worldWidth) {
            this.camera.position.x = this.worldWidth;
        }
        this.camera.position.y += this.xyVelocity.y * deltaSeconds * 4.0f * this.camera.zoom;
        if (this.camera.position.y < 0.0f) {
            this.camera.position.y = 0.0f;
        } else if (this.camera.position.y > (float)this.worldHeight) {
            this.camera.position.y = this.worldHeight;
        }
        if (this.camera.zoom < this.targetZoom) {
            difference = this.targetZoom - this.camera.zoom;
            this.camera.zoom = difference < 0.05f ? this.targetZoom : (this.camera.zoom += 10.0f * deltaSeconds * difference);
        }
        if (this.camera.zoom > this.targetZoom) {
            difference = this.camera.zoom - this.targetZoom;
            this.camera.zoom = difference < 0.05f ? this.targetZoom : (this.camera.zoom -= 10.0f * deltaSeconds * difference);
        }
        this.camera.update();
    }

    public void init(AbstractGameMap gameWorld) {
        this.worldWidth = gameWorld.getWidth();
        this.worldHeight = gameWorld.getHeight();
        this.camera.position.x = this.worldWidth / 2;
        this.camera.position.y = this.worldHeight / 2;
    }

    public OrthographicCamera getCamera() {
        return this.camera;
    }

    public void setMovementX(float amount) {
        this.xyVelocity.x = amount;
    }

    public void setMovementY(float amount) {
        this.xyVelocity.y = amount;
    }

    public void onResize(int width, int height) {
        float tempX = this.camera.position.x;
        float tempY = this.camera.position.y;
        float zoom = this.camera.zoom;
        this.camera.setToOrtho(false, (float)width / 100.0f, (float)height / 100.0f);
        this.camera.position.x = tempX;
        this.camera.position.y = tempY;
        this.camera.zoom = zoom;
    }
}

